#include <stdio.h>
#include <stdlib.h>

#define INF (-1)
#define NILL (-1)
#define TRUE 1
#define FALSE 0

int jeManji(int i, int j) {
	if (i==INF)
		return FALSE;
	if (j==INF)
		return TRUE;
	return i<j;
}

int nadjiMinimum(int *obidjen, double *d, int n) {
	int i;
	int min = INF, minCvor=NILL;
	for (i=1; i<(n+1); i++) {
		if (obidjen[i]==FALSE && jeManji(d[i], min)) {
			min = d[i];
			minCvor = i;
		}
	}
	return minCvor;
}

void relax(double **graf, double *d, int *pret, int u, int v) {
	if (jeManji(d[u]+graf[u][v], d[v])) {
		d[v] = d[u]+graf[u][v];
		pret[v] = u;
	}
}

void dijkstra(double **graf, int *obidjen, double *d, int *pret, int n, double *cekanjeNaGranici)
{
	int u, i, v;
    while((u = nadjiMinimum(obidjen, d, n)) != NILL)
    {
        /*
            cekanje na granici 
        */
        d[u] += cekanjeNaGranici[u];
		obidjen[u] = TRUE;

		for (v=1; v<(n+1); v++) {
			if (graf[u][v]!=INF && obidjen[v]==FALSE)
				relax(graf, d, pret, u, v);
		}
	}
}


void rekonstrukcija(int v, int polaziste, int *pret, double *d)  {
	 
    if (d[v] == INF) {
        printf("-1");
        return;
    }
    

	if (v==polaziste) {
		printf("%d ", v);
	}
	else  {
		rekonstrukcija(pret[v], polaziste, pret, d);
		printf("%d ", v);
	}
}

int main() {
	double **graf;
	int *pret, *obidjen;
    double *d, *granica;
	int i, j, u, v, boja;
    int n, l, k;
    double duzina, ograniceneBrzine, tezinaGrane;
    int granicniPrelaz;
    double vremeCekanjaNaGranici;

    scanf("%d%d", &n, &l);

	graf = (double **)malloc((n+1)*sizeof(double *));
	d = (double *)malloc((n+1)*sizeof(double));
    granica = (double *)malloc((n+1)*sizeof(double));
    
	pret = (int *)malloc((n+1)*sizeof(int));
	obidjen = (int *)malloc((n+1)*sizeof(int));
	
	for (i=1; i<(n+1); i++) {
		graf[i] = (double *)malloc((n+1)*sizeof(double));
        d[i] = INF;
        pret[i] = NILL;
        obidjen[i] = FALSE;
        granica[i] = 0;
	}

	for (i=1; i<(n+1); i++)
		for (j=1; j<(n+1); j++)
			graf[i][j] = INF;

	for (i=0; i<l; i++) {
		scanf("%d%d%lf%lf%d", &u, &v, &duzina, &ograniceneBrzine, &boja);  

//        printf("%d%d%lf%lf%d\n", u, v, duzina, ograniceneBrzine, boja);  
              
        if (boja == 2) {
            ograniceneBrzine = ograniceneBrzine *0.8;
        }
        else
            if (boja == 3) {
                ograniceneBrzine = ograniceneBrzine *0.6;
            }
        tezinaGrane = (duzina / ograniceneBrzine) * 60; // pretvoreno u minute

		graf[u][v] = tezinaGrane;
		graf[v][u] = tezinaGrane;
	}

	scanf("%d", &k);
	for (i=0; i<k; i++)
    {
        scanf("%d%lf", &granicniPrelaz, &vremeCekanjaNaGranici);
        granica[granicniPrelaz] = vremeCekanjaNaGranici;

    }

    int polaziste, skiCentar;
    scanf("%d%d", &polaziste, &skiCentar);
      // printf("%d%d\n", polaziste, skiCentar);


    d[polaziste] = 0;
	dijkstra(graf, obidjen, d, pret, n, granica);

    printf("%lf\n", d[skiCentar]/60.0);
    rekonstrukcija(skiCentar, polaziste,pret, d);
    printf("\n");
	return 0;

}
















